IF NOT OBJECT_ID('TRG_EST_NF_ENT_DAR_PEND_INSERT') IS NULL
	BEGIN 
		DROP TRIGGER [dbo].[TRG_EST_NF_ENT_PED_CP_INCLUI_PENDENCIA]
	END  
GO

/****** Object:  Trigger [dbo].[TRG_EST_NF_ENT_PED_CP_INCLUI_PENDENCIA]    Script Date: 08/01/2016 09:43:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-----------------------------------DELEÇÃO EM EST_NF_ENT_PED_CP-----------------------------------
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_PED_CP_INCLUI_PENDENCIA] ON [dbo].[EST_NF_ENT_PED_CP] FOR DELETE AS
DECLARE @BX_PARCIAL  INT
DECLARE @STS_PED_CP VARCHAR(27)
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PED INT

SELECT 
	@CD_EMP		=	CD_EMP, 
	@CD_FILIAL	=	CD_FILIAL,
	@CD_PED		=	CD_PED
FROM 
	DELETED

--Baixa parcial de pedido de compras
SET @BX_PARCIAL = 1

--Verificando se o pedido de compras possui saldo em produtos
--se caso não retornar então retira da pendência de entrada
SELECT @STS_PED_CP = DBO.TST_EST_PED_CP_STATUS(@CD_EMP,@CD_FILIAL,@CD_PED)
IF @STS_PED_CP <> 'PEDIDO COM ENTREGA EFETUADA'
	begin
		SET @BX_PARCIAL = 0
	end

--Pedido sem entrega alguma
IF @BX_PARCIAL = 0 
	BEGIN
		UPDATE
			p
		SET
			p.STS_PED =  0
		FROM 
			EST_PED_CP p INNER JOIN INSERTED i ON
			p.CD_EMP = i.CD_EMP AND
			p.CD_FILIAL = i.CD_FILIAL AND
			p.CD_PED = i.CD_PED			
	END

--Mudar Status do pedido para entrega parcial
IF @BX_PARCIAL = 1 
	BEGIN
		UPDATE
			p
		SET
			p.STS_PED =  3
		FROM 
			EST_PED_CP p INNER JOIN DELETED d ON
			p.CD_EMP = d.CD_EMP AND
			p.CD_FILIAL = d.CD_FILIAL AND
			p.CD_PED = d.CD_PED			
	END

--Exclui pendência de entrada pedido de compras
DELETE FROM p FROM EST_PED_CP_PENDENCIA p WHERE EXISTS
	(SELECT 
		* 
	 FROM 
		DELETED 
	 WHERE 
		CD_EMP=p.CD_EMP AND 
		CD_FILIAL=p.CD_FILIAL AND 
		CD_PED=p.CD_PED)

--Pendência de entrada pedido de compras
INSERT INTO EST_PED_CP_PENDENCIA (CD_EMP, CD_FILIAL, CD_PED)
	SELECT DISTINCT c.CD_EMP, c.CD_FILIAL, c.CD_PED
    FROM  
	DELETED d 
	INNER JOIN EST_PED_CP c ON c.CD_EMP=d.CD_EMP AND c.CD_FILIAL=d.CD_FILIAL AND c.CD_PED=d.CD_PED
	LEFT JOIN EST_PED_CP_PENDENCIA P ON c.CD_EMP=P.CD_EMP AND c.CD_FILIAL=P.CD_FILIAL AND c.CD_PED=P.CD_PED
	WHERE c.STS_PED NOT IN (2,4) AND c.NAO_CONSTAR_PEND_ENTR=0
	AND P.CD_EMP IS NULL
GO


